/*-
 * Copyright (c) 2003-2006, Maxime Henrion <mux@FreeBSD.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/9/usr.bin/csup/diff.h 204556 2010-03-02 07:26:07Z lulf $
 */
#ifndef _DIFF_H_
#define _DIFF_H_

struct stream;
struct keyword;
struct file_update;

/* Description of an RCS delta. */
struct diffinfo {
	char *di_rcsfile;			/* RCS filename */
	char *di_cvsroot;			/* CVS root prefix */
	char *di_revnum;			/* Revision number */
	char *di_revdate;			/* Revision date */
	char *di_author;			/* Author of the delta */
	char *di_tag;				/* CVS tag, if any */
	char *di_state;				/* State of the branch */
	int di_expand;				/* CVS expansion mode */
};

int		 diff_apply(struct stream *, struct stream *, struct stream *,
		     struct keyword *, struct diffinfo *, int);
int		 diff_reverse(struct stream *, struct stream *,
		     struct stream *, struct keyword *, struct diffinfo *);

#endif /* !_DIFF_H_ */
