/*
 * DO NOT EDIT - This file is automatically generated
 *		 from the following source files:
 *
 * $Id: //depot/aic7xxx/aic7xxx/aic7xxx.seq#58 $
 * $Id: //depot/aic7xxx/aic7xxx/aic7xxx.reg#40 $
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/12/sys/dev/aic7xxx/aic7xxx_reg_print.c 260401 2014-01-07 19:33:17Z scottl $");
#include <dev/aic7xxx/aic7xxx_osm.h>

static ahc_reg_parse_entry_t SCSISEQ_parse_table[] = {
	{ "SCSIRSTO",		0x01, 0x01 },
	{ "ENAUTOATNP",		0x02, 0x02 },
	{ "ENAUTOATNI",		0x04, 0x04 },
	{ "ENAUTOATNO",		0x08, 0x08 },
	{ "ENRSELI",		0x10, 0x10 },
	{ "ENSELI",		0x20, 0x20 },
	{ "ENSELO",		0x40, 0x40 },
	{ "TEMODE",		0x80, 0x80 }
};

int
ahc_scsiseq_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCSISEQ_parse_table, 8, "SCSISEQ",
	    0x00, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SXFRCTL0_parse_table[] = {
	{ "CLRCHN",		0x02, 0x02 },
	{ "SCAMEN",		0x04, 0x04 },
	{ "SPIOEN",		0x08, 0x08 },
	{ "CLRSTCNT",		0x10, 0x10 },
	{ "FAST20",		0x20, 0x20 },
	{ "DFPEXP",		0x40, 0x40 },
	{ "DFON",		0x80, 0x80 }
};

int
ahc_sxfrctl0_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SXFRCTL0_parse_table, 7, "SXFRCTL0",
	    0x01, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SXFRCTL1_parse_table[] = {
	{ "STPWEN",		0x01, 0x01 },
	{ "ACTNEGEN",		0x02, 0x02 },
	{ "ENSTIMER",		0x04, 0x04 },
	{ "ENSPCHK",		0x20, 0x20 },
	{ "SWRAPEN",		0x40, 0x40 },
	{ "BITBUCKET",		0x80, 0x80 },
	{ "STIMESEL",		0x18, 0x18 }
};

int
ahc_sxfrctl1_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SXFRCTL1_parse_table, 7, "SXFRCTL1",
	    0x02, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCSISIGI_parse_table[] = {
	{ "ACKI",		0x01, 0x01 },
	{ "REQI",		0x02, 0x02 },
	{ "BSYI",		0x04, 0x04 },
	{ "SELI",		0x08, 0x08 },
	{ "ATNI",		0x10, 0x10 },
	{ "MSGI",		0x20, 0x20 },
	{ "IOI",		0x40, 0x40 },
	{ "CDI",		0x80, 0x80 },
	{ "P_DATAOUT",		0x00, 0x00 },
	{ "P_DATAOUT_DT",	0x20, 0x20 },
	{ "P_DATAIN",		0x40, 0x40 },
	{ "P_DATAIN_DT",	0x60, 0x60 },
	{ "P_COMMAND",		0x80, 0x80 },
	{ "P_MESGOUT",		0xa0, 0xa0 },
	{ "P_STATUS",		0xc0, 0xc0 },
	{ "PHASE_MASK",		0xe0, 0xe0 },
	{ "P_MESGIN",		0xe0, 0xe0 }
};

int
ahc_scsisigi_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCSISIGI_parse_table, 17, "SCSISIGI",
	    0x03, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCSISIGO_parse_table[] = {
	{ "ACKO",		0x01, 0x01 },
	{ "REQO",		0x02, 0x02 },
	{ "BSYO",		0x04, 0x04 },
	{ "SELO",		0x08, 0x08 },
	{ "ATNO",		0x10, 0x10 },
	{ "MSGO",		0x20, 0x20 },
	{ "IOO",		0x40, 0x40 },
	{ "CDO",		0x80, 0x80 },
	{ "P_DATAOUT",		0x00, 0x00 },
	{ "P_DATAIN",		0x40, 0x40 },
	{ "P_COMMAND",		0x80, 0x80 },
	{ "P_MESGOUT",		0xa0, 0xa0 },
	{ "P_STATUS",		0xc0, 0xc0 },
	{ "PHASE_MASK",		0xe0, 0xe0 },
	{ "P_MESGIN",		0xe0, 0xe0 }
};

int
ahc_scsisigo_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCSISIGO_parse_table, 15, "SCSISIGO",
	    0x03, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCSIRATE_parse_table[] = {
	{ "SINGLE_EDGE",	0x10, 0x10 },
	{ "ENABLE_CRC",		0x40, 0x40 },
	{ "WIDEXFER",		0x80, 0x80 },
	{ "SXFR_ULTRA2",	0x0f, 0x0f },
	{ "SOFS",		0x0f, 0x0f },
	{ "SXFR",		0x70, 0x70 }
};

int
ahc_scsirate_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCSIRATE_parse_table, 6, "SCSIRATE",
	    0x04, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCSIID_parse_table[] = {
	{ "TWIN_CHNLB",		0x80, 0x80 },
	{ "OID",		0x0f, 0x0f },
	{ "TWIN_TID",		0x70, 0x70 },
	{ "SOFS_ULTRA2",	0x7f, 0x7f },
	{ "TID",		0xf0, 0xf0 }
};

int
ahc_scsiid_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCSIID_parse_table, 5, "SCSIID",
	    0x05, regvalue, cur_col, wrap));
}

int
ahc_scsidatl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCSIDATL",
	    0x06, regvalue, cur_col, wrap));
}

int
ahc_scsidath_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCSIDATH",
	    0x07, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t OPTIONMODE_parse_table[] = {
	{ "DIS_MSGIN_DUALEDGE",	0x01, 0x01 },
	{ "AUTO_MSGOUT_DE",	0x02, 0x02 },
	{ "SCSIDATL_IMGEN",	0x04, 0x04 },
	{ "EXPPHASEDIS",	0x08, 0x08 },
	{ "BUSFREEREV",		0x10, 0x10 },
	{ "ATNMGMNTEN",		0x20, 0x20 },
	{ "AUTOACKEN",		0x40, 0x40 },
	{ "AUTORATEEN",		0x80, 0x80 },
	{ "OPTIONMODE_DEFAULTS",0x03, 0x03 }
};

int
ahc_optionmode_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(OPTIONMODE_parse_table, 9, "OPTIONMODE",
	    0x08, regvalue, cur_col, wrap));
}

int
ahc_stcnt_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "STCNT",
	    0x08, regvalue, cur_col, wrap));
}

int
ahc_targcrccnt_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "TARGCRCCNT",
	    0x0a, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t CLRSINT0_parse_table[] = {
	{ "CLRSPIORDY",		0x02, 0x02 },
	{ "CLRSWRAP",		0x08, 0x08 },
	{ "CLRIOERR",		0x08, 0x08 },
	{ "CLRSELINGO",		0x10, 0x10 },
	{ "CLRSELDI",		0x20, 0x20 },
	{ "CLRSELDO",		0x40, 0x40 }
};

int
ahc_clrsint0_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(CLRSINT0_parse_table, 6, "CLRSINT0",
	    0x0b, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SSTAT0_parse_table[] = {
	{ "DMADONE",		0x01, 0x01 },
	{ "SPIORDY",		0x02, 0x02 },
	{ "SDONE",		0x04, 0x04 },
	{ "SWRAP",		0x08, 0x08 },
	{ "IOERR",		0x08, 0x08 },
	{ "SELINGO",		0x10, 0x10 },
	{ "SELDI",		0x20, 0x20 },
	{ "SELDO",		0x40, 0x40 },
	{ "TARGET",		0x80, 0x80 }
};

int
ahc_sstat0_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SSTAT0_parse_table, 9, "SSTAT0",
	    0x0b, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t CLRSINT1_parse_table[] = {
	{ "CLRREQINIT",		0x01, 0x01 },
	{ "CLRPHASECHG",	0x02, 0x02 },
	{ "CLRSCSIPERR",	0x04, 0x04 },
	{ "CLRBUSFREE",		0x08, 0x08 },
	{ "CLRSCSIRSTI",	0x20, 0x20 },
	{ "CLRATNO",		0x40, 0x40 },
	{ "CLRSELTIMEO",	0x80, 0x80 }
};

int
ahc_clrsint1_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(CLRSINT1_parse_table, 7, "CLRSINT1",
	    0x0c, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SSTAT1_parse_table[] = {
	{ "REQINIT",		0x01, 0x01 },
	{ "PHASECHG",		0x02, 0x02 },
	{ "SCSIPERR",		0x04, 0x04 },
	{ "BUSFREE",		0x08, 0x08 },
	{ "PHASEMIS",		0x10, 0x10 },
	{ "SCSIRSTI",		0x20, 0x20 },
	{ "ATNTARG",		0x40, 0x40 },
	{ "SELTO",		0x80, 0x80 }
};

int
ahc_sstat1_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SSTAT1_parse_table, 8, "SSTAT1",
	    0x0c, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SSTAT2_parse_table[] = {
	{ "DUAL_EDGE_ERR",	0x01, 0x01 },
	{ "CRCREQERR",		0x02, 0x02 },
	{ "CRCENDERR",		0x04, 0x04 },
	{ "CRCVALERR",		0x08, 0x08 },
	{ "EXP_ACTIVE",		0x10, 0x10 },
	{ "SHVALID",		0x40, 0x40 },
	{ "OVERRUN",		0x80, 0x80 },
	{ "SFCNT",		0x1f, 0x1f }
};

int
ahc_sstat2_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SSTAT2_parse_table, 8, "SSTAT2",
	    0x0d, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SSTAT3_parse_table[] = {
	{ "OFFCNT",		0x0f, 0x0f },
	{ "U2OFFCNT",		0x7f, 0x7f },
	{ "SCSICNT",		0xf0, 0xf0 }
};

int
ahc_sstat3_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SSTAT3_parse_table, 3, "SSTAT3",
	    0x0e, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCSIID_ULTRA2_parse_table[] = {
	{ "OID",		0x0f, 0x0f },
	{ "TID",		0xf0, 0xf0 }
};

int
ahc_scsiid_ultra2_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCSIID_ULTRA2_parse_table, 2, "SCSIID_ULTRA2",
	    0x0f, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SIMODE0_parse_table[] = {
	{ "ENDMADONE",		0x01, 0x01 },
	{ "ENSPIORDY",		0x02, 0x02 },
	{ "ENSDONE",		0x04, 0x04 },
	{ "ENSWRAP",		0x08, 0x08 },
	{ "ENIOERR",		0x08, 0x08 },
	{ "ENSELINGO",		0x10, 0x10 },
	{ "ENSELDI",		0x20, 0x20 },
	{ "ENSELDO",		0x40, 0x40 }
};

int
ahc_simode0_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SIMODE0_parse_table, 8, "SIMODE0",
	    0x10, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SIMODE1_parse_table[] = {
	{ "ENREQINIT",		0x01, 0x01 },
	{ "ENPHASECHG",		0x02, 0x02 },
	{ "ENSCSIPERR",		0x04, 0x04 },
	{ "ENBUSFREE",		0x08, 0x08 },
	{ "ENPHASEMIS",		0x10, 0x10 },
	{ "ENSCSIRST",		0x20, 0x20 },
	{ "ENATNTARG",		0x40, 0x40 },
	{ "ENSELTIMO",		0x80, 0x80 }
};

int
ahc_simode1_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SIMODE1_parse_table, 8, "SIMODE1",
	    0x11, regvalue, cur_col, wrap));
}

int
ahc_scsibusl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCSIBUSL",
	    0x12, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SXFRCTL2_parse_table[] = {
	{ "CMDDMAEN",		0x08, 0x08 },
	{ "AUTORSTDIS",		0x10, 0x10 },
	{ "ASYNC_SETUP",	0x07, 0x07 }
};

int
ahc_sxfrctl2_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SXFRCTL2_parse_table, 3, "SXFRCTL2",
	    0x13, regvalue, cur_col, wrap));
}

int
ahc_scsibush_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCSIBUSH",
	    0x13, regvalue, cur_col, wrap));
}

int
ahc_shaddr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SHADDR",
	    0x14, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SELTIMER_parse_table[] = {
	{ "STAGE1",		0x01, 0x01 },
	{ "STAGE2",		0x02, 0x02 },
	{ "STAGE3",		0x04, 0x04 },
	{ "STAGE4",		0x08, 0x08 },
	{ "STAGE5",		0x10, 0x10 },
	{ "STAGE6",		0x20, 0x20 }
};

int
ahc_seltimer_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SELTIMER_parse_table, 6, "SELTIMER",
	    0x18, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SELID_parse_table[] = {
	{ "ONEBIT",		0x08, 0x08 },
	{ "SELID_MASK",		0xf0, 0xf0 }
};

int
ahc_selid_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SELID_parse_table, 2, "SELID",
	    0x19, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCAMCTL_parse_table[] = {
	{ "DFLTTID",		0x10, 0x10 },
	{ "ALTSTIM",		0x20, 0x20 },
	{ "CLRSCAMSELID",	0x40, 0x40 },
	{ "ENSCAMSELO",		0x80, 0x80 },
	{ "SCAMLVL",		0x03, 0x03 }
};

int
ahc_scamctl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCAMCTL_parse_table, 5, "SCAMCTL",
	    0x1a, regvalue, cur_col, wrap));
}

int
ahc_targid_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "TARGID",
	    0x1b, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SPIOCAP_parse_table[] = {
	{ "SSPIOCPS",		0x01, 0x01 },
	{ "ROM",		0x02, 0x02 },
	{ "EEPROM",		0x04, 0x04 },
	{ "SEEPROM",		0x08, 0x08 },
	{ "EXT_BRDCTL",		0x10, 0x10 },
	{ "SOFTCMDEN",		0x20, 0x20 },
	{ "SOFT0",		0x40, 0x40 },
	{ "SOFT1",		0x80, 0x80 }
};

int
ahc_spiocap_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SPIOCAP_parse_table, 8, "SPIOCAP",
	    0x1b, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t BRDCTL_parse_table[] = {
	{ "BRDCTL0",		0x01, 0x01 },
	{ "BRDSTB_ULTRA2",	0x01, 0x01 },
	{ "BRDCTL1",		0x02, 0x02 },
	{ "BRDRW_ULTRA2",	0x02, 0x02 },
	{ "BRDRW",		0x04, 0x04 },
	{ "BRDDAT2",		0x04, 0x04 },
	{ "BRDCS",		0x08, 0x08 },
	{ "BRDDAT3",		0x08, 0x08 },
	{ "BRDSTB",		0x10, 0x10 },
	{ "BRDDAT4",		0x10, 0x10 },
	{ "BRDDAT5",		0x20, 0x20 },
	{ "BRDDAT6",		0x40, 0x40 },
	{ "BRDDAT7",		0x80, 0x80 }
};

int
ahc_brdctl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(BRDCTL_parse_table, 13, "BRDCTL",
	    0x1d, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SEECTL_parse_table[] = {
	{ "SEEDI",		0x01, 0x01 },
	{ "SEEDO",		0x02, 0x02 },
	{ "SEECK",		0x04, 0x04 },
	{ "SEECS",		0x08, 0x08 },
	{ "SEERDY",		0x10, 0x10 },
	{ "SEEMS",		0x20, 0x20 },
	{ "EXTARBREQ",		0x40, 0x40 },
	{ "EXTARBACK",		0x80, 0x80 }
};

int
ahc_seectl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SEECTL_parse_table, 8, "SEECTL",
	    0x1e, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SBLKCTL_parse_table[] = {
	{ "XCVR",		0x01, 0x01 },
	{ "SELWIDE",		0x02, 0x02 },
	{ "ENAB20",		0x04, 0x04 },
	{ "SELBUSB",		0x08, 0x08 },
	{ "ENAB40",		0x08, 0x08 },
	{ "AUTOFLUSHDIS",	0x20, 0x20 },
	{ "DIAGLEDON",		0x40, 0x40 },
	{ "DIAGLEDEN",		0x80, 0x80 }
};

int
ahc_sblkctl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SBLKCTL_parse_table, 8, "SBLKCTL",
	    0x1f, regvalue, cur_col, wrap));
}

int
ahc_busy_targets_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "BUSY_TARGETS",
	    0x20, regvalue, cur_col, wrap));
}

int
ahc_ultra_enb_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "ULTRA_ENB",
	    0x30, regvalue, cur_col, wrap));
}

int
ahc_disc_dsb_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "DISC_DSB",
	    0x32, regvalue, cur_col, wrap));
}

int
ahc_cmdsize_table_tail_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "CMDSIZE_TABLE_TAIL",
	    0x34, regvalue, cur_col, wrap));
}

int
ahc_mwi_residual_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "MWI_RESIDUAL",
	    0x38, regvalue, cur_col, wrap));
}

int
ahc_next_queued_scb_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "NEXT_QUEUED_SCB",
	    0x39, regvalue, cur_col, wrap));
}

int
ahc_msg_out_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "MSG_OUT",
	    0x3a, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t DMAPARAMS_parse_table[] = {
	{ "FIFORESET",		0x01, 0x01 },
	{ "FIFOFLUSH",		0x02, 0x02 },
	{ "DIRECTION",		0x04, 0x04 },
	{ "HDMAEN",		0x08, 0x08 },
	{ "HDMAENACK",		0x08, 0x08 },
	{ "SDMAEN",		0x10, 0x10 },
	{ "SDMAENACK",		0x10, 0x10 },
	{ "SCSIEN",		0x20, 0x20 },
	{ "WIDEODD",		0x40, 0x40 },
	{ "PRELOADEN",		0x80, 0x80 }
};

int
ahc_dmaparams_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(DMAPARAMS_parse_table, 10, "DMAPARAMS",
	    0x3b, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SEQ_FLAGS_parse_table[] = {
	{ "NO_DISCONNECT",	0x01, 0x01 },
	{ "SPHASE_PENDING",	0x02, 0x02 },
	{ "DPHASE_PENDING",	0x04, 0x04 },
	{ "CMDPHASE_PENDING",	0x08, 0x08 },
	{ "TARG_CMD_PENDING",	0x10, 0x10 },
	{ "DPHASE",		0x20, 0x20 },
	{ "NO_CDB_SENT",	0x40, 0x40 },
	{ "TARGET_CMD_IS_TAGGED",0x40, 0x40 },
	{ "NOT_IDENTIFIED",	0x80, 0x80 }
};

int
ahc_seq_flags_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SEQ_FLAGS_parse_table, 9, "SEQ_FLAGS",
	    0x3c, regvalue, cur_col, wrap));
}

int
ahc_saved_scsiid_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SAVED_SCSIID",
	    0x3d, regvalue, cur_col, wrap));
}

int
ahc_saved_lun_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SAVED_LUN",
	    0x3e, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t LASTPHASE_parse_table[] = {
	{ "MSGI",		0x20, 0x20 },
	{ "IOI",		0x40, 0x40 },
	{ "CDI",		0x80, 0x80 },
	{ "P_DATAOUT",		0x00, 0x00 },
	{ "P_BUSFREE",		0x01, 0x01 },
	{ "P_DATAIN",		0x40, 0x40 },
	{ "P_COMMAND",		0x80, 0x80 },
	{ "P_MESGOUT",		0xa0, 0xa0 },
	{ "P_STATUS",		0xc0, 0xc0 },
	{ "PHASE_MASK",		0xe0, 0xe0 },
	{ "P_MESGIN",		0xe0, 0xe0 }
};

int
ahc_lastphase_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(LASTPHASE_parse_table, 11, "LASTPHASE",
	    0x3f, regvalue, cur_col, wrap));
}

int
ahc_waiting_scbh_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "WAITING_SCBH",
	    0x40, regvalue, cur_col, wrap));
}

int
ahc_disconnected_scbh_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "DISCONNECTED_SCBH",
	    0x41, regvalue, cur_col, wrap));
}

int
ahc_free_scbh_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "FREE_SCBH",
	    0x42, regvalue, cur_col, wrap));
}

int
ahc_complete_scbh_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "COMPLETE_SCBH",
	    0x43, regvalue, cur_col, wrap));
}

int
ahc_hscb_addr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "HSCB_ADDR",
	    0x44, regvalue, cur_col, wrap));
}

int
ahc_shared_data_addr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SHARED_DATA_ADDR",
	    0x48, regvalue, cur_col, wrap));
}

int
ahc_kernel_qinpos_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "KERNEL_QINPOS",
	    0x4c, regvalue, cur_col, wrap));
}

int
ahc_qinpos_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "QINPOS",
	    0x4d, regvalue, cur_col, wrap));
}

int
ahc_qoutpos_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "QOUTPOS",
	    0x4e, regvalue, cur_col, wrap));
}

int
ahc_kernel_tqinpos_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "KERNEL_TQINPOS",
	    0x4f, regvalue, cur_col, wrap));
}

int
ahc_tqinpos_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "TQINPOS",
	    0x50, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t ARG_1_parse_table[] = {
	{ "SPARE",		0x01, 0x01 },
	{ "CONT_TARG_SESSION",	0x02, 0x02 },
	{ "CONT_MSG_LOOP",	0x04, 0x04 },
	{ "EXIT_MSG_LOOP",	0x08, 0x08 },
	{ "MSGOUT_PHASEMIS",	0x10, 0x10 },
	{ "SEND_REJ",		0x20, 0x20 },
	{ "SEND_SENSE",		0x40, 0x40 },
	{ "SEND_MSG",		0x80, 0x80 }
};

int
ahc_arg_1_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(ARG_1_parse_table, 8, "ARG_1",
	    0x51, regvalue, cur_col, wrap));
}

int
ahc_arg_2_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "ARG_2",
	    0x52, regvalue, cur_col, wrap));
}

int
ahc_last_msg_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "LAST_MSG",
	    0x53, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCSISEQ_TEMPLATE_parse_table[] = {
	{ "ENAUTOATNP",		0x02, 0x02 },
	{ "ENAUTOATNI",		0x04, 0x04 },
	{ "ENAUTOATNO",		0x08, 0x08 },
	{ "ENRSELI",		0x10, 0x10 },
	{ "ENSELI",		0x20, 0x20 },
	{ "ENSELO",		0x40, 0x40 }
};

int
ahc_scsiseq_template_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCSISEQ_TEMPLATE_parse_table, 6, "SCSISEQ_TEMPLATE",
	    0x54, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t HA_274_BIOSGLOBAL_parse_table[] = {
	{ "HA_274_EXTENDED_TRANS",0x01, 0x01 }
};

int
ahc_ha_274_biosglobal_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(HA_274_BIOSGLOBAL_parse_table, 1, "HA_274_BIOSGLOBAL",
	    0x56, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SEQ_FLAGS2_parse_table[] = {
	{ "SCB_DMA",		0x01, 0x01 },
	{ "TARGET_MSG_PENDING",	0x02, 0x02 }
};

int
ahc_seq_flags2_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SEQ_FLAGS2_parse_table, 2, "SEQ_FLAGS2",
	    0x57, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCSICONF_parse_table[] = {
	{ "ENSPCHK",		0x20, 0x20 },
	{ "RESET_SCSI",		0x40, 0x40 },
	{ "TERM_ENB",		0x80, 0x80 },
	{ "HSCSIID",		0x07, 0x07 },
	{ "HWSCSIID",		0x0f, 0x0f }
};

int
ahc_scsiconf_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCSICONF_parse_table, 5, "SCSICONF",
	    0x5a, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t INTDEF_parse_table[] = {
	{ "EDGE_TRIG",		0x80, 0x80 },
	{ "VECTOR",		0x0f, 0x0f }
};

int
ahc_intdef_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(INTDEF_parse_table, 2, "INTDEF",
	    0x5c, regvalue, cur_col, wrap));
}

int
ahc_hostconf_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "HOSTCONF",
	    0x5d, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t HA_274_BIOSCTRL_parse_table[] = {
	{ "CHANNEL_B_PRIMARY",	0x08, 0x08 },
	{ "BIOSMODE",		0x30, 0x30 },
	{ "BIOSDISABLED",	0x30, 0x30 }
};

int
ahc_ha_274_biosctrl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(HA_274_BIOSCTRL_parse_table, 3, "HA_274_BIOSCTRL",
	    0x5f, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SEQCTL_parse_table[] = {
	{ "LOADRAM",		0x01, 0x01 },
	{ "SEQRESET",		0x02, 0x02 },
	{ "STEP",		0x04, 0x04 },
	{ "BRKADRINTEN",	0x08, 0x08 },
	{ "FASTMODE",		0x10, 0x10 },
	{ "FAILDIS",		0x20, 0x20 },
	{ "PAUSEDIS",		0x40, 0x40 },
	{ "PERRORDIS",		0x80, 0x80 }
};

int
ahc_seqctl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SEQCTL_parse_table, 8, "SEQCTL",
	    0x60, regvalue, cur_col, wrap));
}

int
ahc_seqram_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SEQRAM",
	    0x61, regvalue, cur_col, wrap));
}

int
ahc_seqaddr0_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SEQADDR0",
	    0x62, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SEQADDR1_parse_table[] = {
	{ "SEQADDR1_MASK",	0x01, 0x01 }
};

int
ahc_seqaddr1_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SEQADDR1_parse_table, 1, "SEQADDR1",
	    0x63, regvalue, cur_col, wrap));
}

int
ahc_accum_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "ACCUM",
	    0x64, regvalue, cur_col, wrap));
}

int
ahc_sindex_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SINDEX",
	    0x65, regvalue, cur_col, wrap));
}

int
ahc_dindex_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "DINDEX",
	    0x66, regvalue, cur_col, wrap));
}

int
ahc_allones_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "ALLONES",
	    0x69, regvalue, cur_col, wrap));
}

int
ahc_none_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "NONE",
	    0x6a, regvalue, cur_col, wrap));
}

int
ahc_allzeros_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "ALLZEROS",
	    0x6a, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t FLAGS_parse_table[] = {
	{ "CARRY",		0x01, 0x01 },
	{ "ZERO",		0x02, 0x02 }
};

int
ahc_flags_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(FLAGS_parse_table, 2, "FLAGS",
	    0x6b, regvalue, cur_col, wrap));
}

int
ahc_sindir_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SINDIR",
	    0x6c, regvalue, cur_col, wrap));
}

int
ahc_dindir_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "DINDIR",
	    0x6d, regvalue, cur_col, wrap));
}

int
ahc_function1_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "FUNCTION1",
	    0x6e, regvalue, cur_col, wrap));
}

int
ahc_stack_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "STACK",
	    0x6f, regvalue, cur_col, wrap));
}

int
ahc_targ_offset_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "TARG_OFFSET",
	    0x70, regvalue, cur_col, wrap));
}

int
ahc_sram_base_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SRAM_BASE",
	    0x70, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t DSCOMMAND0_parse_table[] = {
	{ "CIOPARCKEN",		0x01, 0x01 },
	{ "USCBSIZE32",		0x02, 0x02 },
	{ "RAMPS",		0x04, 0x04 },
	{ "INTSCBRAMSEL",	0x08, 0x08 },
	{ "EXTREQLCK",		0x10, 0x10 },
	{ "MPARCKEN",		0x20, 0x20 },
	{ "DPARCKEN",		0x40, 0x40 },
	{ "CACHETHEN",		0x80, 0x80 }
};

int
ahc_dscommand0_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(DSCOMMAND0_parse_table, 8, "DSCOMMAND0",
	    0x84, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t BCTL_parse_table[] = {
	{ "ENABLE",		0x01, 0x01 },
	{ "ACE",		0x08, 0x08 }
};

int
ahc_bctl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(BCTL_parse_table, 2, "BCTL",
	    0x84, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t BUSTIME_parse_table[] = {
	{ "BON",		0x0f, 0x0f },
	{ "BOFF",		0xf0, 0xf0 }
};

int
ahc_bustime_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(BUSTIME_parse_table, 2, "BUSTIME",
	    0x85, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t DSCOMMAND1_parse_table[] = {
	{ "HADDLDSEL0",		0x01, 0x01 },
	{ "HADDLDSEL1",		0x02, 0x02 },
	{ "DSLATT",		0xfc, 0xfc }
};

int
ahc_dscommand1_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(DSCOMMAND1_parse_table, 3, "DSCOMMAND1",
	    0x85, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t BUSSPD_parse_table[] = {
	{ "STBON",		0x07, 0x07 },
	{ "STBOFF",		0x38, 0x38 },
	{ "DFTHRSH_75",		0x80, 0x80 },
	{ "DFTHRSH",		0xc0, 0xc0 },
	{ "DFTHRSH_100",	0xc0, 0xc0 }
};

int
ahc_busspd_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(BUSSPD_parse_table, 5, "BUSSPD",
	    0x86, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t HS_MAILBOX_parse_table[] = {
	{ "SEQ_MAILBOX",	0x0f, 0x0f },
	{ "HOST_TQINPOS",	0x80, 0x80 },
	{ "HOST_MAILBOX",	0xf0, 0xf0 }
};

int
ahc_hs_mailbox_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(HS_MAILBOX_parse_table, 3, "HS_MAILBOX",
	    0x86, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t DSPCISTATUS_parse_table[] = {
	{ "DFTHRSH_100",	0xc0, 0xc0 }
};

int
ahc_dspcistatus_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(DSPCISTATUS_parse_table, 1, "DSPCISTATUS",
	    0x86, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t HCNTRL_parse_table[] = {
	{ "CHIPRST",		0x01, 0x01 },
	{ "CHIPRSTACK",		0x01, 0x01 },
	{ "INTEN",		0x02, 0x02 },
	{ "PAUSE",		0x04, 0x04 },
	{ "IRQMS",		0x08, 0x08 },
	{ "SWINT",		0x10, 0x10 },
	{ "POWRDN",		0x40, 0x40 }
};

int
ahc_hcntrl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(HCNTRL_parse_table, 7, "HCNTRL",
	    0x87, regvalue, cur_col, wrap));
}

int
ahc_haddr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "HADDR",
	    0x88, regvalue, cur_col, wrap));
}

int
ahc_hcnt_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "HCNT",
	    0x8c, regvalue, cur_col, wrap));
}

int
ahc_scbptr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCBPTR",
	    0x90, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t INTSTAT_parse_table[] = {
	{ "SEQINT",		0x01, 0x01 },
	{ "CMDCMPLT",		0x02, 0x02 },
	{ "SCSIINT",		0x04, 0x04 },
	{ "BRKADRINT",		0x08, 0x08 },
	{ "BAD_PHASE",		0x01, 0x01 },
	{ "INT_PEND",		0x0f, 0x0f },
	{ "SEND_REJECT",	0x11, 0x11 },
	{ "PROTO_VIOLATION",	0x21, 0x21 },
	{ "NO_MATCH",		0x31, 0x31 },
	{ "IGN_WIDE_RES",	0x41, 0x41 },
	{ "PDATA_REINIT",	0x51, 0x51 },
	{ "HOST_MSG_LOOP",	0x61, 0x61 },
	{ "BAD_STATUS",		0x71, 0x71 },
	{ "PERR_DETECTED",	0x81, 0x81 },
	{ "DATA_OVERRUN",	0x91, 0x91 },
	{ "MKMSG_FAILED",	0xa1, 0xa1 },
	{ "MISSED_BUSFREE",	0xb1, 0xb1 },
	{ "SCB_MISMATCH",	0xc1, 0xc1 },
	{ "NO_FREE_SCB",	0xd1, 0xd1 },
	{ "OUT_OF_RANGE",	0xe1, 0xe1 },
	{ "SEQINT_MASK",	0xf1, 0xf1 }
};

int
ahc_intstat_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(INTSTAT_parse_table, 21, "INTSTAT",
	    0x91, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t ERROR_parse_table[] = {
	{ "ILLHADDR",		0x01, 0x01 },
	{ "ILLSADDR",		0x02, 0x02 },
	{ "ILLOPCODE",		0x04, 0x04 },
	{ "SQPARERR",		0x08, 0x08 },
	{ "DPARERR",		0x10, 0x10 },
	{ "MPARERR",		0x20, 0x20 },
	{ "PCIERRSTAT",		0x40, 0x40 },
	{ "CIOPARERR",		0x80, 0x80 }
};

int
ahc_error_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(ERROR_parse_table, 8, "ERROR",
	    0x92, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t CLRINT_parse_table[] = {
	{ "CLRSEQINT",		0x01, 0x01 },
	{ "CLRCMDINT",		0x02, 0x02 },
	{ "CLRSCSIINT",		0x04, 0x04 },
	{ "CLRBRKADRINT",	0x08, 0x08 },
	{ "CLRPARERR",		0x10, 0x10 }
};

int
ahc_clrint_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(CLRINT_parse_table, 5, "CLRINT",
	    0x92, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t DFCNTRL_parse_table[] = {
	{ "FIFORESET",		0x01, 0x01 },
	{ "FIFOFLUSH",		0x02, 0x02 },
	{ "DIRECTION",		0x04, 0x04 },
	{ "HDMAEN",		0x08, 0x08 },
	{ "HDMAENACK",		0x08, 0x08 },
	{ "SDMAEN",		0x10, 0x10 },
	{ "SDMAENACK",		0x10, 0x10 },
	{ "SCSIEN",		0x20, 0x20 },
	{ "WIDEODD",		0x40, 0x40 },
	{ "PRELOADEN",		0x80, 0x80 }
};

int
ahc_dfcntrl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(DFCNTRL_parse_table, 10, "DFCNTRL",
	    0x93, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t DFSTATUS_parse_table[] = {
	{ "FIFOEMP",		0x01, 0x01 },
	{ "FIFOFULL",		0x02, 0x02 },
	{ "DFTHRESH",		0x04, 0x04 },
	{ "HDONE",		0x08, 0x08 },
	{ "MREQPEND",		0x10, 0x10 },
	{ "FIFOQWDEMP",		0x20, 0x20 },
	{ "DFCACHETH",		0x40, 0x40 },
	{ "PRELOAD_AVAIL",	0x80, 0x80 }
};

int
ahc_dfstatus_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(DFSTATUS_parse_table, 8, "DFSTATUS",
	    0x94, regvalue, cur_col, wrap));
}

int
ahc_dfwaddr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "DFWADDR",
	    0x95, regvalue, cur_col, wrap));
}

int
ahc_dfraddr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "DFRADDR",
	    0x97, regvalue, cur_col, wrap));
}

int
ahc_dfdat_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "DFDAT",
	    0x99, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCBCNT_parse_table[] = {
	{ "SCBAUTO",		0x80, 0x80 },
	{ "SCBCNT_MASK",	0x1f, 0x1f }
};

int
ahc_scbcnt_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCBCNT_parse_table, 2, "SCBCNT",
	    0x9a, regvalue, cur_col, wrap));
}

int
ahc_qinfifo_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "QINFIFO",
	    0x9b, regvalue, cur_col, wrap));
}

int
ahc_qincnt_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "QINCNT",
	    0x9c, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t CRCCONTROL1_parse_table[] = {
	{ "TARGCRCCNTEN",	0x04, 0x04 },
	{ "TARGCRCENDEN",	0x08, 0x08 },
	{ "CRCREQCHKEN",	0x10, 0x10 },
	{ "CRCENDCHKEN",	0x20, 0x20 },
	{ "CRCVALCHKEN",	0x40, 0x40 },
	{ "CRCONSEEN",		0x80, 0x80 }
};

int
ahc_crccontrol1_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(CRCCONTROL1_parse_table, 6, "CRCCONTROL1",
	    0x9d, regvalue, cur_col, wrap));
}

int
ahc_qoutfifo_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "QOUTFIFO",
	    0x9d, regvalue, cur_col, wrap));
}

int
ahc_qoutcnt_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "QOUTCNT",
	    0x9e, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCSIPHASE_parse_table[] = {
	{ "DATA_OUT_PHASE",	0x01, 0x01 },
	{ "DATA_IN_PHASE",	0x02, 0x02 },
	{ "MSG_OUT_PHASE",	0x04, 0x04 },
	{ "MSG_IN_PHASE",	0x08, 0x08 },
	{ "COMMAND_PHASE",	0x10, 0x10 },
	{ "STATUS_PHASE",	0x20, 0x20 },
	{ "DATA_PHASE_MASK",	0x03, 0x03 }
};

int
ahc_scsiphase_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCSIPHASE_parse_table, 7, "SCSIPHASE",
	    0x9e, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SFUNCT_parse_table[] = {
	{ "ALT_MODE",		0x80, 0x80 }
};

int
ahc_sfunct_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SFUNCT_parse_table, 1, "SFUNCT",
	    0x9f, regvalue, cur_col, wrap));
}

int
ahc_scb_base_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_BASE",
	    0xa0, regvalue, cur_col, wrap));
}

int
ahc_scb_cdb_ptr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_CDB_PTR",
	    0xa0, regvalue, cur_col, wrap));
}

int
ahc_scb_residual_sgptr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_RESIDUAL_SGPTR",
	    0xa4, regvalue, cur_col, wrap));
}

int
ahc_scb_scsi_status_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_SCSI_STATUS",
	    0xa8, regvalue, cur_col, wrap));
}

int
ahc_scb_target_phases_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_TARGET_PHASES",
	    0xa9, regvalue, cur_col, wrap));
}

int
ahc_scb_target_data_dir_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_TARGET_DATA_DIR",
	    0xaa, regvalue, cur_col, wrap));
}

int
ahc_scb_target_itag_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_TARGET_ITAG",
	    0xab, regvalue, cur_col, wrap));
}

int
ahc_scb_dataptr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_DATAPTR",
	    0xac, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCB_DATACNT_parse_table[] = {
	{ "SG_LAST_SEG",	0x80, 0x80 },
	{ "SG_HIGH_ADDR_BITS",	0x7f, 0x7f }
};

int
ahc_scb_datacnt_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCB_DATACNT_parse_table, 2, "SCB_DATACNT",
	    0xb0, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCB_SGPTR_parse_table[] = {
	{ "SG_LIST_NULL",	0x01, 0x01 },
	{ "SG_FULL_RESID",	0x02, 0x02 },
	{ "SG_RESID_VALID",	0x04, 0x04 }
};

int
ahc_scb_sgptr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCB_SGPTR_parse_table, 3, "SCB_SGPTR",
	    0xb4, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCB_CONTROL_parse_table[] = {
	{ "DISCONNECTED",	0x04, 0x04 },
	{ "ULTRAENB",		0x08, 0x08 },
	{ "MK_MESSAGE",		0x10, 0x10 },
	{ "TAG_ENB",		0x20, 0x20 },
	{ "DISCENB",		0x40, 0x40 },
	{ "TARGET_SCB",		0x80, 0x80 },
	{ "STATUS_RCVD",	0x80, 0x80 },
	{ "SCB_TAG_TYPE",	0x03, 0x03 }
};

int
ahc_scb_control_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCB_CONTROL_parse_table, 8, "SCB_CONTROL",
	    0xb8, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCB_SCSIID_parse_table[] = {
	{ "TWIN_CHNLB",		0x80, 0x80 },
	{ "OID",		0x0f, 0x0f },
	{ "TWIN_TID",		0x70, 0x70 },
	{ "TID",		0xf0, 0xf0 }
};

int
ahc_scb_scsiid_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCB_SCSIID_parse_table, 4, "SCB_SCSIID",
	    0xb9, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SCB_LUN_parse_table[] = {
	{ "SCB_XFERLEN_ODD",	0x80, 0x80 },
	{ "LID",		0x3f, 0x3f }
};

int
ahc_scb_lun_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SCB_LUN_parse_table, 2, "SCB_LUN",
	    0xba, regvalue, cur_col, wrap));
}

int
ahc_scb_tag_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_TAG",
	    0xbb, regvalue, cur_col, wrap));
}

int
ahc_scb_cdb_len_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_CDB_LEN",
	    0xbc, regvalue, cur_col, wrap));
}

int
ahc_scb_scsirate_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_SCSIRATE",
	    0xbd, regvalue, cur_col, wrap));
}

int
ahc_scb_scsioffset_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_SCSIOFFSET",
	    0xbe, regvalue, cur_col, wrap));
}

int
ahc_scb_next_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_NEXT",
	    0xbf, regvalue, cur_col, wrap));
}

int
ahc_scb_64_spare_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_64_SPARE",
	    0xc0, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SEECTL_2840_parse_table[] = {
	{ "DO_2840",		0x01, 0x01 },
	{ "CK_2840",		0x02, 0x02 },
	{ "CS_2840",		0x04, 0x04 }
};

int
ahc_seectl_2840_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SEECTL_2840_parse_table, 3, "SEECTL_2840",
	    0xc0, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t STATUS_2840_parse_table[] = {
	{ "DI_2840",		0x01, 0x01 },
	{ "EEPROM_TF",		0x80, 0x80 },
	{ "ADSEL",		0x1e, 0x1e },
	{ "BIOS_SEL",		0x60, 0x60 }
};

int
ahc_status_2840_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(STATUS_2840_parse_table, 4, "STATUS_2840",
	    0xc1, regvalue, cur_col, wrap));
}

int
ahc_scb_64_btt_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCB_64_BTT",
	    0xd0, regvalue, cur_col, wrap));
}

int
ahc_cchaddr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "CCHADDR",
	    0xe0, regvalue, cur_col, wrap));
}

int
ahc_cchcnt_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "CCHCNT",
	    0xe8, regvalue, cur_col, wrap));
}

int
ahc_ccsgram_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "CCSGRAM",
	    0xe9, regvalue, cur_col, wrap));
}

int
ahc_ccsgaddr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "CCSGADDR",
	    0xea, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t CCSGCTL_parse_table[] = {
	{ "CCSGRESET",		0x01, 0x01 },
	{ "SG_FETCH_NEEDED",	0x02, 0x02 },
	{ "CCSGEN",		0x08, 0x08 },
	{ "CCSGDONE",		0x80, 0x80 }
};

int
ahc_ccsgctl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(CCSGCTL_parse_table, 4, "CCSGCTL",
	    0xeb, regvalue, cur_col, wrap));
}

int
ahc_ccscbram_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "CCSCBRAM",
	    0xec, regvalue, cur_col, wrap));
}

int
ahc_ccscbaddr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "CCSCBADDR",
	    0xed, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t CCSCBCTL_parse_table[] = {
	{ "CCSCBRESET",		0x01, 0x01 },
	{ "CCSCBDIR",		0x04, 0x04 },
	{ "CCSCBEN",		0x08, 0x08 },
	{ "CCARREN",		0x10, 0x10 },
	{ "ARRDONE",		0x40, 0x40 },
	{ "CCSCBDONE",		0x80, 0x80 }
};

int
ahc_ccscbctl_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(CCSCBCTL_parse_table, 6, "CCSCBCTL",
	    0xee, regvalue, cur_col, wrap));
}

int
ahc_ccscbcnt_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "CCSCBCNT",
	    0xef, regvalue, cur_col, wrap));
}

int
ahc_scbbaddr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SCBBADDR",
	    0xf0, regvalue, cur_col, wrap));
}

int
ahc_ccscbptr_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "CCSCBPTR",
	    0xf1, regvalue, cur_col, wrap));
}

int
ahc_hnscb_qoff_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "HNSCB_QOFF",
	    0xf4, regvalue, cur_col, wrap));
}

int
ahc_snscb_qoff_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SNSCB_QOFF",
	    0xf6, regvalue, cur_col, wrap));
}

int
ahc_sdscb_qoff_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(NULL, 0, "SDSCB_QOFF",
	    0xf8, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t QOFF_CTLSTA_parse_table[] = {
	{ "SDSCB_ROLLOVER",	0x10, 0x10 },
	{ "SNSCB_ROLLOVER",	0x20, 0x20 },
	{ "SCB_AVAIL",		0x40, 0x40 },
	{ "SCB_QSIZE_256",	0x06, 0x06 },
	{ "SCB_QSIZE",		0x07, 0x07 }
};

int
ahc_qoff_ctlsta_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(QOFF_CTLSTA_parse_table, 5, "QOFF_CTLSTA",
	    0xfa, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t DFF_THRSH_parse_table[] = {
	{ "RD_DFTHRSH_MIN",	0x00, 0x00 },
	{ "WR_DFTHRSH_MIN",	0x00, 0x00 },
	{ "RD_DFTHRSH_25",	0x01, 0x01 },
	{ "RD_DFTHRSH_50",	0x02, 0x02 },
	{ "RD_DFTHRSH_63",	0x03, 0x03 },
	{ "RD_DFTHRSH_75",	0x04, 0x04 },
	{ "RD_DFTHRSH_85",	0x05, 0x05 },
	{ "RD_DFTHRSH_90",	0x06, 0x06 },
	{ "RD_DFTHRSH",		0x07, 0x07 },
	{ "RD_DFTHRSH_MAX",	0x07, 0x07 },
	{ "WR_DFTHRSH_25",	0x10, 0x10 },
	{ "WR_DFTHRSH_50",	0x20, 0x20 },
	{ "WR_DFTHRSH_63",	0x30, 0x30 },
	{ "WR_DFTHRSH_75",	0x40, 0x40 },
	{ "WR_DFTHRSH_85",	0x50, 0x50 },
	{ "WR_DFTHRSH_90",	0x60, 0x60 },
	{ "WR_DFTHRSH",		0x70, 0x70 },
	{ "WR_DFTHRSH_MAX",	0x70, 0x70 }
};

int
ahc_dff_thrsh_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(DFF_THRSH_parse_table, 18, "DFF_THRSH",
	    0xfb, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SG_CACHE_SHADOW_parse_table[] = {
	{ "LAST_SEG_DONE",	0x01, 0x01 },
	{ "LAST_SEG",		0x02, 0x02 },
	{ "SG_ADDR_MASK",	0xf8, 0xf8 }
};

int
ahc_sg_cache_shadow_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SG_CACHE_SHADOW_parse_table, 3, "SG_CACHE_SHADOW",
	    0xfc, regvalue, cur_col, wrap));
}

static ahc_reg_parse_entry_t SG_CACHE_PRE_parse_table[] = {
	{ "LAST_SEG_DONE",	0x01, 0x01 },
	{ "LAST_SEG",		0x02, 0x02 },
	{ "SG_ADDR_MASK",	0xf8, 0xf8 }
};

int
ahc_sg_cache_pre_print(u_int regvalue, u_int *cur_col, u_int wrap)
{
	return (ahc_print_register(SG_CACHE_PRE_parse_table, 3, "SG_CACHE_PRE",
	    0xfc, regvalue, cur_col, wrap));
}

