/*-
 * Copyright (c) 2013-2014 Robert N. M. Watson
 * All rights reserved.
 *
 * This software was developed by SRI International and the University of
 * Cambridge Computer Laboratory under DARPA/AFRL contract (FA8750-10-C-0237)
 * ("CTSRD"), as part of the DARPA CRASH research programme.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/11/stand/mips/beri/loader/loader.h 344290 2019-02-19 18:48:17Z kevans $
 */

#ifndef _BOOT_LOADER_H_
#define	_BOOT_LOADER_H_

/* beri_console.c */
extern struct console	 altera_jtag_uart_console;

/* beri_disk.c */
extern struct devsw	 beri_cfi_disk;
extern struct devsw	 beri_sdcard_disk;

/* devicename.c */
struct env_var;
int	 beri_arch_setcurrdev(struct env_var *, int, const void *);
char	*beri_arch_fmtdev(void *);
int	 beri_arch_getdev(void **, const char *, const char **);

/* exec.c */
extern struct file_format	beri_elf;

/* main.c */
extern int		 boot2_argc;
extern char		**boot2_argv;
extern char		**boot2_envv;
extern struct bootinfo	 boot2_bootinfo;

/* metadata.c */
int	md_load64(char *args, vm_offset_t *modulep, vm_offset_t *dtbp);

#endif /* !_BOOT_LOADER_H_ */
