/*	$FreeBSD: stable/11/contrib/ipfilter/lib/verbose.c 369186 2021-01-31 04:32:46Z cy $	*/

/*
 * Copyright (C) 2012 by Darren Reed.
 *
 * See the IPFILTER.LICENCE file for details on licencing.
 *
 * $Id$
 */

# include <stdarg.h>
#include <stdio.h>

#include "ipf.h"
#include "opts.h"


void	verbose(int level, char *fmt, ...)
{
	va_list pvar;

	va_start(pvar, fmt);

	if (opts & OPT_VERBOSE)
		vprintf(fmt, pvar);
	va_end(pvar);
}


void	ipfkverbose(char *fmt, ...)
{
	va_list pvar;

	va_start(pvar, fmt);

	if (opts & OPT_VERBOSE)
		verbose(0x1fffffff, fmt, pvar);
	va_end(pvar);
}
