#!/bin/sh

# panic: Queues are not empty when handling SHUTDOWN-COMPLETE
# cpuid = 10
# time = 1650546082
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe00e49be680
# vpanic() at vpanic+0x17f/frame 0xfffffe00e49be6d0
# panic() at panic+0x43/frame 0xfffffe00e49be730
# sctp_handle_shutdown_complete() at sctp_handle_shutdown_complete+0xea/frame 0xfffffe00e49be750
# sctp_process_control() at sctp_process_control+0x1561/frame 0xfffffe00e49bea90
# sctp_common_input_processing() at sctp_common_input_processing+0x514/frame 0xfffffe00e49bec00
# sctp6_input_with_port() at sctp6_input_with_port+0x228/frame 0xfffffe00e49becf0
# sctp6_input() at sctp6_input+0xb/frame 0xfffffe00e49bed00
# ip6_input() at ip6_input+0xc2f/frame 0xfffffe00e49bede0
# swi_net() at swi_net+0x191/frame 0xfffffe00e49bee60
# ithread_loop() at ithread_loop+0x279/frame 0xfffffe00e49beef0
# fork_exit() at fork_exit+0x80/frame 0xfffffe00e49bef30
# fork_trampoline() at fork_trampoline+0xe/frame 0xfffffe00e49bef30
# --- trap 0, rip = 0, rsp = 0, rbp = 0 ---
# KDB: enter: panic
# [ thread pid 12 tid 100077 ]
# Stopped at      kdb_enter+0x32: movq    $0,0x12797a3(%rip)
# db> x/s version
# FreeBSD 14.0-CURRENT #0 main-n254961-b91a48693a53e: Thu Apr 21 09:39:27 CEST 2022
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

[ `uname -p` != "amd64" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller51.c <<EOF
// https://syzkaller.appspot.com/bug?id=358f4bcd3d53267e6f5f069677688bad5cf7c1f4
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+341e9ebd9d24ca7dc62a@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[3] = {0xffffffffffffffff, 0xffffffffffffffff, 0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  res = syscall(SYS_socket, 0x1cul, 1ul, 0x84);
  if (res != -1)
    r[0] = res;
  *(uint8_t*)0x20000000 = 0x1c;
  *(uint8_t*)0x20000001 = 0x1c;
  *(uint16_t*)0x20000002 = htobe16(0x4e22);
  *(uint32_t*)0x20000004 = 0;
  memset((void*)0x20000008, 0, 16);
  *(uint32_t*)0x20000018 = 0;
  syscall(SYS_bind, r[0], 0x20000000ul, 0x1cul);
  syscall(SYS_listen, r[0], 5);
  res = syscall(SYS_socket, 0x1cul, 1ul, 0x84);
  if (res != -1)
    r[1] = res;
  memset((void*)0x20000240, 202, 1);
  *(uint8_t*)0x20000040 = 0x1c;
  *(uint8_t*)0x20000041 = 0x1c;
  *(uint16_t*)0x20000042 = htobe16(0x4e22);
  *(uint32_t*)0x20000044 = 0;
  *(uint64_t*)0x20000048 = htobe64(0);
  *(uint64_t*)0x20000050 = htobe64(1);
  *(uint32_t*)0x20000058 = 0;
  syscall(SYS_sendto, r[1], 0x20000240ul, 1ul, 0ul, 0x20000040ul, 0x1cul);
  syscall(SYS_dup2, r[0], r[1]);
  res = syscall(SYS_accept, r[1], 0ul, 0ul);
  if (res != -1)
    r[2] = res;
  *(uint64_t*)0x20001980 = 0;
  *(uint32_t*)0x20001988 = 0;
  *(uint64_t*)0x20001990 = 0x200018c0;
  *(uint64_t*)0x200018c0 = 0x20000400;
  memcpy(
      (void*)0x20000400,
      "\xe1\xb9\x03\xdc\x43\xbc\x11\x92\xcb\x81\xb0\x96\xe0\x09\xde\x05\x09\x0b"
      "\x44\x42\x6a\x68\x20\x0d\x0a\x78\x94\x0a\xbc\xcb\x4d\x0b\x1d\x3e\xc6\x6a"
      "\xc2\x43\x46\x14\x08\x20\x01\x43\x3e\xf2\xc1\xb6\x6a\x0e\x5e\x13\xa8\xcf"
      "\x99\x01\x1d\x5a\xb4\xe1\x7e\xa4\x98\x7d\x56\xb5\x86\xa3\xbb\x1e\x3e\xb5"
      "\x85\x89\x43\xf9\x0d\xee\x7e\x8d\xc5\xac\x60\xed\x23\x62\xc7\x05\x0b\x3b"
      "\x37\x6c\x77\x77\x5f\x1e\x0f\xa0\x90\x50\xc1\x97\x45\x47\x7f\xe7\x64\xff"
      "\x92\x61\x9f\x9c\x06\xee\x37\x89\xf8\x81\x6e\xf7\xeb\xe5\xe1\xbd\xa8\xcc"
      "\x50\xce\x6b\x9b\x7e\x9a\x62\x5c\x71\xd4\x41\x55\x90\x6b\xe5\x92\x55\xe0"
      "\x3e\xc5\xfd\xfd\xbb\x5d\x2c\xf2\x70\x22\xdb\x96\x07\x02\xe6\xae\x67\xb2"
      "\xcd\x1b\xf6\xab\x30\x3a\xfd\x24\x5d\xb7\x37\x95\x21\x4c\xc6\x8a\x29\x50"
      "\xec\x8d\x33\x21\x6a\x93\x20\x30\x43\xe4\x54\xeb\x98\x2b\x40\x9a\x2a\x1d"
      "\x48\x77\xc8\xf3\x06\xdf\xa3\x80\x07\xab\x8c\x6e\x30\x13\x84\x4d\xf4\x48"
      "\x1e\x5b\x0f\xbd\x84\xe0\x17\xbe\x81\xc9\x47\xc5\x6b\x0b\xc0\x70\x74\xcb"
      "\x6d\xe1\xe3\xeb\xdc\xe8\xbf\x72\x22\x92\x0b\x2b\xfe\xda\x7f\xcf\x96",
      251);
  *(uint64_t*)0x200018c8 = 0xfb;
  *(uint64_t*)0x200018d0 = 0;
  *(uint64_t*)0x200018d8 = 0;
  *(uint64_t*)0x200018e0 = 0x20000600;
  *(uint64_t*)0x200018e8 = 0;
  *(uint64_t*)0x200018f0 = 0;
  *(uint64_t*)0x200018f8 = 0;
  *(uint64_t*)0x20001900 = 0;
  *(uint64_t*)0x20001908 = 0;
  *(uint64_t*)0x20001910 = 0;
  *(uint64_t*)0x20001918 = 0;
  *(uint64_t*)0x20001920 = 0;
  *(uint64_t*)0x20001928 = 0;
  *(uint64_t*)0x20001930 = 0;
  *(uint64_t*)0x20001938 = 0;
  *(uint64_t*)0x20001940 = 0;
  *(uint64_t*)0x20001948 = 0;
  *(uint32_t*)0x20001998 = 9;
  *(uint64_t*)0x200019a0 = 0;
  *(uint32_t*)0x200019a8 = 0;
  *(uint32_t*)0x200019ac = 0x101;
  syscall(SYS_sendmsg, r[2], 0x20001980ul, 0x20104ul);
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller51 -Wall -Wextra -O0 /tmp/syzkaller51.c || exit 1

kldstat | grep -q sctp   || { kldload sctp.ko && loaded=1; }

(cd /tmp; timeout 3m ./syzkaller51)

rm -rf /tmp/syzkaller51 /tmp/syzkaller51.c /tmp/syzkaller.*
[ $loaded ] && kldunload sctp.ko
exit 0
