#!/bin/sh

# panic: mutex Giant owned at ../../../kern/kern_thread.c:1409
# cpuid = 0
# time = 1688501618
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe0171ba2510
# vpanic() at vpanic+0x150/frame 0xfffffe0171ba2560
# panic() at panic+0x43/frame 0xfffffe0171ba25c0
# __mtx_assert() at __mtx_assert+0xc4/frame 0xfffffe0171ba25d0
# thread_suspend_check() at thread_suspend_check+0x38/frame 0xfffffe0171ba2610
# sig_intr() at sig_intr+0x78/frame 0xfffffe0171ba2640
# fork1() at fork1+0x238/frame 0xfffffe0171ba26c0
# kproc_create() at kproc_create+0x92/frame 0xfffffe0171ba2790
# kproc_kthread_add() at kproc_kthread_add+0xdd/frame 0xfffffe0171ba28b0
# zthr_create_timer() at zthr_create_timer+0x109/frame 0xfffffe0171ba2930
# arc_init() at arc_init+0x1b44/frame 0xfffffe0171ba2970
# dmu_init() at dmu_init+0x31/frame 0xfffffe0171ba2980
# spa_init() at spa_init+0xed/frame 0xfffffe0171ba29a0
# zfs_kmod_init() at zfs_kmod_init+0x1f/frame 0xfffffe0171ba29c0
# zfs_modevent() at zfs_modevent+0module_register_init() at module_register_init+0xb0/frame 0xfffffe0171ba2a10
# linker_load_module() at linker_load_module+0xbd2/frame 0xfffffe0171ba2d10
# kern_kldload() at kern_kldload+0x16f/frame 0xfffffe0171ba2d60
# vfs_byname_kld() at vfs_byname_kld+0x31/frame 0xfffffe0171ba2da0
# sys_mount() at sys_mount+0xa9/frame 0xfffffe0171ba2e00
# amd64_syscall() at amd64_syscall+0x150/frame 0xfffffe0171ba2f30
# fast_syscall_common() at fast_syscall_common+0xf8/frame 0xfffffe0171ba2f30
# --- syscall (0, FreeBSD ELF64, syscall), rip = 0x823f70e9a, rsp = 0x82513af78, rbp = 0x82513af90 KDB: enter: panic
# [ thread pid 43886 tid 178779 ]
# Stopped at      kdb_enter+0x32: movq    $0,0xde5863(%rip)
# db> x/s version
# version:        FreeBSD 14.0-CURRENT #0 main-n263953-d7614c010c762: Tue Jul  4 19:29:44 CEST 2023
# pho@mercat1.netperf.freebsd.org:/usr/src/sys/amd64/compile/PHO
# db> 

uname -p | grep -Eq "amd64|i386" || exit 0
[ `id -u ` -ne 0 ] && echo "Must be root!" && exit 1

. ../default.cfg
prog=$(basename "$0" .sh)
cat > /tmp/$prog.c <<EOF
// https://syzkaller.appspot.com/bug?id=85a795d15aa54816d63f71f69bfb3a2c61635472
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+dce5858451a2329877ff@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <time.h>
#include <unistd.h>

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i = 0;
  for (; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void loop(void)
{
  int i, call, thread;
  for (call = 0; call < 1; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      event_timedwait(&th->done, 50);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
}

void execute_call(int call)
{
  switch (call) {
  case 0:
    memcpy((void*)0x20000440, "zfs\000", 4);
    syscall(SYS_mount, 0x20000440ul, 0ul, 0x8300648ul, 0ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/$prog -Wall -Wextra -O0 /tmp/$prog.c -lpthread || exit 1

(cd /tmp; timeout 2m ./$prog)

rm -rf /tmp/$prog /tmp/$prog.c /tmp/syzkaller.*
exit 0
