#!/bin/sh

# panic: Bad link elm 0xfffff8001a83db00 prev->next != elm
# cpuid = 21
# time = 1605387390
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe0100a983e0
# vpanic() at vpanic+0x182/frame 0xfffffe0100a98430
# panic() at panic+0x43/frame 0xfffffe0100a98490
# _callout_stop_safe() at _callout_stop_safe+0x726/frame 0xfffffe0100a98520
# filt_timerdetach() at filt_timerdetach+0x20/frame 0xfffffe0100a98540
# kqueue_drain() at kqueue_drain+0x2c8/frame 0xfffffe0100a98580
# kqueue_close() at kqueue_close+0x7d/frame 0xfffffe0100a985c0
# _fdrop() at _fdrop+0x1b/frame 0xfffffe0100a985e0
# closef() at closef+0x1ea/frame 0xfffffe0100a98670
# fdescfree_fds() at fdescfree_fds+0x8c/frame 0xfffffe0100a986d0
# fdescfree() at fdescfree+0x3cd/frame 0xfffffe0100a987a0
# exit1() at exit1+0x487/frame 0xfffffe0100a98810
# sigexit() at sigexit+0x15c/frame 0xfffffe0100a98ae0
# postsig() at postsig+0x2cc/frame 0xfffffe0100a98bb0
# ast() at ast+0x5eb/frame 0xfffffe0100a98bf0
# doreti_ast() at doreti_ast+0x1f/frame 0x7fffffffe570
# KDB: enter: panic
# [ thread pid 82279 tid 100717 ]
# Stopped at      kdb_enter+0x37: movq    $0,0x10aa7f6(%rip)
# db> x/s version
# version:        FreeBSD 13.0-CURRENT #0 r367672: Sat Nov 14 08:42:14 CET 2020
# pho@t2.osted.lan:/usr/src/sys/amd64/compile/PHO
# db>

[ `uname -p` != "amd64" ] && exit 0

# Fixed by r367849

. ../default.cfg
cat > /tmp/syzkaller26.c <<EOF
// https://syzkaller.appspot.com/bug?id=95ac7e30218c63bc9322b1dd775101f8f88de4ff
// autogenerated by syzkaller (https://github.com/google/syzkaller)
// Reported-by: syzbot+1b27e0237aa22d8adffa@syzkaller.appspotmail.com

#define _GNU_SOURCE

#include <sys/types.h>

#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused = 0;
  for (;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5 * 1000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[1] = {0xffffffffffffffff};

void execute_one(void)
{
  intptr_t res = 0;
  res = syscall(SYS_kqueue);
  if (res != -1)
    r[0] = res;
  *(uint64_t*)0x20000000 = 3;
  *(uint16_t*)0x20000008 = 0xfff3;
  *(uint16_t*)0x2000000a = 0x4000;
  *(uint32_t*)0x2000000c = 0x1000000;
  *(uint64_t*)0x20000010 = 0xe;
  *(uint64_t*)0x20000018 = 0xff;
  *(uint64_t*)0x20000020 = 2;
  *(uint64_t*)0x20000028 = 2;
  *(uint64_t*)0x20000030 = 4;
  *(uint64_t*)0x20000038 = 0xffffffffffffff90;
  *(uint64_t*)0x20000040 = 0x101;
  *(uint16_t*)0x20000048 = 0xfff6;
  *(uint16_t*)0x2000004a = 0x22;
  *(uint32_t*)0x2000004c = 0x20;
  *(uint64_t*)0x20000050 = 0xe1;
  *(uint64_t*)0x20000058 = -1;
  *(uint64_t*)0x20000060 = 0x81;
  *(uint64_t*)0x20000068 = 4;
  *(uint64_t*)0x20000070 = 0x8000;
  *(uint64_t*)0x20000078 = 9;
  *(uint64_t*)0x20000080 = 0;
  *(uint16_t*)0x20000088 = 0xfff9;
  *(uint16_t*)0x2000008a = 0xefc9;
  *(uint32_t*)0x2000008c = 4;
  *(uint64_t*)0x20000090 = 0;
  *(uint64_t*)0x20000098 = 0x400;
  *(uint64_t*)0x200000a0 = 0x2e77;
  *(uint64_t*)0x200000a8 = 2;
  *(uint64_t*)0x200000b0 = 0x7fffffff;
  *(uint64_t*)0x200000b8 = 7;
  syscall(SYS_kevent, r[0], 0x20000000ul, 3ul, 0x200000c0ul, 9ul, 0ul);
}
int main(void)
{
  sleep(2);	/* pho */
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 7ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller26 -Wall -Wextra -O0 /tmp/syzkaller26.c ||
    exit 1

(cd ../testcases/swap; ./swap -t 1m -i 20 -h > /dev/null 2>&1) &
for i in `jot 256`; do
	(cd /tmp; timeout 3m ./syzkaller26) &
done
wait

rm -rf /tmp/syzkaller26 /tmp/syzkaller26.c /tmp/syzkaller.*
exit 0
