/*-
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (c) 2021 Vladimir Kondratyev <wulf@FreeBSD.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LINUXKPI_ASM_PROCESSOR_H_
#define	_LINUXKPI_ASM_PROCESSOR_H_

#include <sys/types.h>
#include <machine/cpufunc.h>
#include <machine/cpu.h>

#if defined(__i386__) || defined(__amd64__)
#define	X86_VENDOR_INTEL	0
#define	X86_VENDOR_CYRIX	1
#define	X86_VENDOR_AMD		2
#define	X86_VENDOR_UMC		3
#define	X86_VENDOR_CENTAUR	5
#define	X86_VENDOR_TRANSMETA	7
#define	X86_VENDOR_NSC		8
#define	X86_VENDOR_HYGON	9
#define	X86_VENDOR_NUM		12

#define	X86_VENDOR_UNKNOWN	0xff

struct cpuinfo_x86 {
	uint8_t		x86;
	uint8_t		x86_model;
	uint16_t	x86_clflush_size;
	uint16_t	x86_max_cores;
	uint8_t		x86_vendor;
};

extern struct cpuinfo_x86	boot_cpu_data;
extern struct cpuinfo_x86	*__cpu_data;
#define	cpu_data(cpu)	__cpu_data[cpu]
#endif

#define	cpu_relax()	cpu_spinwait()

#endif	/* _LINUXKPI_ASM_PROCESSOR_H_ */
