/*-
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (c) 1994-1996 Søren Schmidt
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Linux syscalls return negative errno's, we do positive and map them
 * Reference:
 *   FreeBSD: src/sys/sys/errno.h
 *   Linux:   include/uapi/asm-generic/errno-base.h
 *            include/uapi/asm-generic/errno.h
 *
 * XXX: The "XXX" comments below should be replaced with rationale
 *      for the errno value chosen.
 */
static const int linux_errtbl[ELAST + 1] = {
	/* [0, 9] */
	[0] = -0,
	[EPERM] = -LINUX_EPERM,
	[ENOENT] = -LINUX_ENOENT,
	[ESRCH] = -LINUX_ESRCH,
	[EINTR] = -LINUX_EINTR,
	[EIO] = -LINUX_EIO,
	[ENXIO] = -LINUX_ENXIO,
	[E2BIG] = -LINUX_E2BIG,
	[ENOEXEC] = -LINUX_ENOEXEC,
	[EBADF] = -LINUX_EBADF,

	/* [10, 19] */
	[ECHILD] = -LINUX_ECHILD,
	[EDEADLK] = -LINUX_EDEADLK,
	[ENOMEM] = -LINUX_ENOMEM,
	[EACCES] = -LINUX_EACCES,
	[EFAULT] = -LINUX_EFAULT,
	[ENOTBLK] = -LINUX_ENOTBLK,
	[EBUSY] = -LINUX_EBUSY,
	[EEXIST] = -LINUX_EEXIST,
	[EXDEV] = -LINUX_EXDEV,
	[ENODEV] = -LINUX_ENODEV,

	/* [20, 29] */
	[ENOTDIR] = -LINUX_ENOTDIR,
	[EISDIR] = -LINUX_EISDIR,
	[EINVAL] = -LINUX_EINVAL,
	[ENFILE] = -LINUX_ENFILE,
	[EMFILE] = -LINUX_EMFILE,
	[ENOTTY] = -LINUX_ENOTTY,
	[ETXTBSY] = -LINUX_ETXTBSY,
	[EFBIG] = -LINUX_EFBIG,
	[ENOSPC] = -LINUX_ENOSPC,
	[ESPIPE] = -LINUX_ESPIPE,

	/* [30, 39] */
	[EROFS] = -LINUX_EROFS,
	[EMLINK] = -LINUX_EMLINK,
	[EPIPE] = -LINUX_EPIPE,
	[EDOM] = -LINUX_EDOM,
	[ERANGE] = -LINUX_ERANGE,
	[EAGAIN] = -LINUX_EAGAIN,
	[EINPROGRESS] = -LINUX_EINPROGRESS,
	[EALREADY] = -LINUX_EALREADY,
	[ENOTSOCK] = -LINUX_ENOTSOCK,
	[EDESTADDRREQ] = -LINUX_EDESTADDRREQ,

	/* [40, 49] */
	[EMSGSIZE] = -LINUX_EMSGSIZE,
	[EPROTOTYPE] = -LINUX_EPROTOTYPE,
	[ENOPROTOOPT] = -LINUX_ENOPROTOOPT,
	[EPROTONOSUPPORT] = -LINUX_EPROTONOTSUPPORT,
	[ESOCKTNOSUPPORT] = -LINUX_ESOCKNOTSUPPORT,
	[EOPNOTSUPP] = -LINUX_EOPNOTSUPPORT,
	[EPFNOSUPPORT] = -LINUX_EPFNOTSUPPORT,
	[EAFNOSUPPORT] = -LINUX_EAFNOTSUPPORT,
	[EADDRINUSE] = -LINUX_EADDRINUSE,
	[EADDRNOTAVAIL] = -LINUX_EADDRNOTAVAIL,

	/* [50, 59] */
	[ENETDOWN] = -LINUX_ENETDOWN,
	[ENETUNREACH] = -LINUX_ENETUNREACH,
	[ENETRESET] = -LINUX_ENETRESET,
	[ECONNABORTED] = -LINUX_ECONNABORTED,
	[ECONNRESET] = -LINUX_ECONNRESET,
	[ENOBUFS] = -LINUX_ENOBUFS,
	[EISCONN] = -LINUX_EISCONN,
	[ENOTCONN] = -LINUX_ENOTCONN,
	[ESHUTDOWN] = -LINUX_ESHUTDOWN,
	[ETOOMANYREFS] = -LINUX_ETOOMANYREFS,

	/* [60, 69] */
	[ETIMEDOUT] = -LINUX_ETIMEDOUT,
	[ECONNREFUSED] = -LINUX_ECONNREFUSED,
	[ELOOP] = -LINUX_ELOOP,
	[ENAMETOOLONG] = -LINUX_ENAMETOOLONG,
	[EHOSTDOWN] = -LINUX_EHOSTDOWN,
	[EHOSTUNREACH] = -LINUX_EHOSTUNREACH,
	[ENOTEMPTY] = -LINUX_ENOTEMPTY,
	[EPROCLIM] = -LINUX_EAGAIN,	/* XXX */
	[EUSERS] = -LINUX_EUSERS,
	[EDQUOT] = -LINUX_EDQUOT,

	/* [70, 79] */
	[ESTALE] = -LINUX_ESTALE,
	[EREMOTE] = -LINUX_EREMOTE,
	[EBADRPC] = -LINUX_ENXIO,	/* XXX */
	[ERPCMISMATCH] = -LINUX_ENXIO,	/* XXX */
	[EPROGUNAVAIL] = -LINUX_ENXIO,	/* XXX */
	[EPROGMISMATCH] = -LINUX_ENXIO,	/* XXX */
	[EPROCUNAVAIL] = -LINUX_ENXIO,	/* XXX */
	[ENOLCK] = -LINUX_ENOLCK,
	[ENOSYS] = -LINUX_ENOSYS,
	[EFTYPE] = -LINUX_EBADF,	/* XXX */

	/* [80, 89] */
	[EAUTH] = -LINUX_ENXIO,		/* XXX */
	[ENEEDAUTH] = -LINUX_ENXIO,	/* XXX */
	[EIDRM] = -LINUX_EIDRM,
	[ENOMSG] = -LINUX_ENOMSG,
	[EOVERFLOW] = -LINUX_EOVERFLOW,
	[ECANCELED] = -LINUX_ECANCELED,
	[EILSEQ] = -LINUX_EILSEQ,
	[ENOATTR] = -LINUX_ENODATA,	/* XXX */
	[EDOOFUS] = -LINUX_EINVAL,	/* XXX */
	[EBADMSG] = -LINUX_EBADMSG,

	/* [90, 99] */
	[EMULTIHOP] = -LINUX_EMULTIHOP,
	[ENOLINK] = -LINUX_ENOLINK,
	[EPROTO] = -LINUX_EPROTO,
	[ENOTCAPABLE] = -LINUX_EPERM,	/* XXX */
	[ECAPMODE] = -LINUX_EPERM,	/* XXX */
	[ENOTRECOVERABLE] = -LINUX_ENOTRECOVERABLE,
	[EOWNERDEAD] = -LINUX_EOWNERDEAD,
	[EINTEGRITY] = -LINUX_EINVAL,	/* XXX */
};

_Static_assert(ELAST == 97,
    "missing errno entries in linux_errtbl");

static const int linux_to_bsd_errtbl[LINUX_ELAST + 1] = {
	/* [0, 9] */
	[0] = 0,
	[LINUX_EPERM] = EPERM,
	[LINUX_ENOENT] = ENOENT,
	[LINUX_ESRCH] = ESRCH,
	[LINUX_EINTR] = EINTR,
	[LINUX_EIO] = EIO,
	[LINUX_ENXIO] = ENXIO,
	[LINUX_E2BIG] = E2BIG,
	[LINUX_ENOEXEC] = ENOENT,
	[LINUX_EBADF] = EBADF,

	/* [10, 19] */
	[LINUX_ECHILD] = ECHILD,
	[LINUX_EAGAIN] = EAGAIN,
	[LINUX_ENOMEM] = ENOMEM,
	[LINUX_EACCES] = EACCES,
	[LINUX_EFAULT] = EFAULT,
	[LINUX_ENOTBLK] = ENOTBLK,
	[LINUX_EBUSY] = EBUSY,
	[LINUX_EEXIST] = EEXIST,
	[LINUX_EXDEV] = EXDEV,
	[LINUX_ENODEV] = ENODEV,

	/* [20, 29] */
	[LINUX_ENOTDIR] = ENOTDIR,
	[LINUX_EISDIR] = EISDIR,
	[LINUX_EINVAL] = EINVAL,
	[LINUX_ENFILE] = ENFILE,
	[LINUX_EMFILE] = EMFILE,
	[LINUX_ENOTTY] = ENOTTY,
	[LINUX_ETXTBSY] = ETXTBSY,
	[LINUX_EFBIG] = EFBIG,
	[LINUX_ENOSPC] = ENOSPC,
	[LINUX_ESPIPE] = ESPIPE,

	/* [30, 39] */
	[LINUX_EROFS] = EROFS,
	[LINUX_EMLINK] = EMLINK,
	[LINUX_EPIPE] = EPIPE,
	[LINUX_EDOM] = EDOM,
	[LINUX_ERANGE] = ERANGE,
	[LINUX_EDEADLK] = EDEADLK,
	[LINUX_ENAMETOOLONG] = ENAMETOOLONG,
	[LINUX_ENOLCK] = ENOLCK,
	[LINUX_ENOSYS] = ENOSYS,
	[LINUX_ENOTEMPTY] = ENOTEMPTY,

	/* [40, 49] */
	[LINUX_ELOOP] = ELOOP,
	[41] = EINVAL,
	[LINUX_ENOMSG] = ENOMSG,
	[LINUX_EIDRM] = EIDRM,
	[LINUX_ECHRNG] = EINVAL,	/* XXX */
	[LINUX_EL2NSYNC] = EINVAL,	/* XXX */
	[LINUX_EL3HLT] = EINVAL,	/* XXX */
	[LINUX_EL3RST] = EINVAL,	/* XXX */
	[LINUX_ELNRNG] = EINVAL,	/* XXX */
	[LINUX_EUNATCH] = EINVAL,	/* XXX */

	/* [50, 59] */
	[LINUX_ENOCSI] = EINVAL,	/* XXX */
	[LINUX_EL2HLT] = EINVAL,	/* XXX */
	[LINUX_EBADE] = EINVAL,		/* XXX */
	[LINUX_EBADR] = EINVAL,		/* XXX */
	[LINUX_EXFULL] = EINVAL,	/* XXX */
	[LINUX_ENOANO] = EINVAL,	/* XXX */
	[LINUX_EBADRQC] = EINVAL,	/* XXX */
	[LINUX_EBADSLT] = EINVAL,	/* XXX */
	[58] = EINVAL,
	[LINUX_EBFONT] = EINVAL,	/* XXX */

	/* [60, 69] */
	[LINUX_ENOSTR] = EINVAL,	/* XXX */
	[LINUX_ENODATA] = ENOATTR,	/* XXX */
	[LINUX_ENOTIME] = EINVAL,	/* XXX */
	[LINUX_ENOSR] = EINVAL,		/* XXX */
	[LINUX_ENONET] = EINVAL,	/* XXX */
	[LINUX_ENOPKG] = EINVAL,	/* XXX */
	[LINUX_EREMOTE] = EREMOTE,
	[LINUX_ENOLINK] = ENOLINK,
	[LINUX_EADV] = EINVAL,		/* XXX */
	[LINUX_ESRMNT] = EINVAL,	/* XXX */

	/* [70, 79] */
	[LINUX_ECOMM] = EINVAL,		/* XXX */
	[LINUX_EPROTO] = EPROTO,
	[LINUX_EMULTIHOP] = EMULTIHOP,
	[LINUX_EDOTDOT] = EINVAL,	/* XXX */
	[LINUX_EBADMSG] = EBADMSG,
	[LINUX_EOVERFLOW] = EOVERFLOW,
	[LINUX_ENOTUNIQ] = EINVAL,	/* XXX */
	[LINUX_EBADFD] = EBADF,		/* XXX */
	[LINUX_EREMCHG] = EINVAL,	/* XXX */
	[LINUX_ELIBACC] = EINVAL,	/* XXX */

	/* [80, 89] */
	[LINUX_ELIBBAD] = EINVAL,	/* XXX */
	[LINUX_ELIBSCN] = EINVAL,	/* XXX */
	[LINUX_ELIBMAX] = EINVAL,	/* XXX */
	[LINUX_ELIBEXEC] = EINVAL,	/* XXX */
	[LINUX_EILSEQ] = EILSEQ,
	[LINUX_ERESTART] = EAGAIN,	/* XXX */
	[LINUX_ESTRPIPE] = EINVAL,	/* XXX */
	[LINUX_EUSERS] = EUSERS,
	[LINUX_ENOTSOCK] = ENOTSOCK,
	[LINUX_EDESTADDRREQ] = EDESTADDRREQ,

	/* [90, 99] */
	[LINUX_EMSGSIZE] = EMSGSIZE,
	[LINUX_EPROTOTYPE] = EPROTOTYPE,
	[LINUX_ENOPROTOOPT] = ENOPROTOOPT,
	[LINUX_EPROTONOTSUPPORT] = EPROTONOSUPPORT,
	[LINUX_ESOCKNOTSUPPORT] = EPROTONOSUPPORT,	/* XXX */
	[LINUX_EOPNOTSUPPORT] = EOPNOTSUPP,
	[LINUX_EPFNOTSUPPORT] = EPFNOSUPPORT,
	[LINUX_EAFNOTSUPPORT] = EAFNOSUPPORT,
	[LINUX_EADDRINUSE] = EADDRINUSE,
	[LINUX_EADDRNOTAVAIL] = EADDRNOTAVAIL,

	/* [100, 109] */
	[LINUX_ENETDOWN] = ENETDOWN,
	[LINUX_ENETUNREACH] = ENETUNREACH,
	[LINUX_ENETRESET] = ENETRESET,
	[LINUX_ECONNABORTED] = ECONNABORTED,
	[LINUX_ECONNRESET] = ECONNRESET,
	[LINUX_ENOBUFS] = ENOBUFS,
	[LINUX_EISCONN] = EISCONN,
	[LINUX_ENOTCONN] = ENOTCONN,
	[LINUX_ESHUTDOWN] = ESHUTDOWN,
	[LINUX_ETOOMANYREFS] = ETOOMANYREFS,

	/* [110, 119] */
	[LINUX_ETIMEDOUT] = ETIMEDOUT,
	[LINUX_ECONNREFUSED] = ECONNREFUSED,
	[LINUX_EHOSTDOWN] = EHOSTDOWN,
	[LINUX_EHOSTUNREACH] = EHOSTUNREACH,
	[LINUX_EALREADY] = EALREADY,
	[LINUX_EINPROGRESS] = EINPROGRESS,
	[LINUX_ESTALE] = ESTALE,
	[LINUX_EUCLEAN] = EINVAL,		/* XXX */
	[LINUX_ENOTNAM] = EINVAL,		/* XXX */
	[LINUX_ENAVAIL] = EINVAL,		/* XXX */

	/* [120, 129] */
	[LINUX_EISNAM] = EINVAL,		/* XXX */
	[LINUX_EREMOTEIO] = EINVAL,		/* XXX */
	[LINUX_EDQUOT] = EDQUOT,
	[LINUX_ENOMEDIUM] = EIO,		/* XXX */
	[LINUX_EMEDIUMTYPE] = EIO,		/* XXX */
	[LINUX_ECANCELED] = ECANCELED,
	[LINUX_ENOKEY] = EIO,			/* XXX */
	[LINUX_EKEYEXPIRED] = EIO,		/* XXX */
	[LINUX_EKEYREVOKED] = EIO,		/* XXX */
	[LINUX_EKEYREJECTED] = EIO,		/* XXX */

	/* [130, 139] */
	[LINUX_EOWNERDEAD] = EOWNERDEAD,
	[LINUX_ENOTRECOVERABLE] = ENOTRECOVERABLE,
	[LINUX_ERFKILL] = ENETDOWN,		/* XXX */
	[LINUX_EHWPOISON] = EINVAL,		/* XXX */
};

_Static_assert(LINUX_ELAST == 133,
    "missing errno entries in linux_to_bsd_errtbl");
